//
//  YHTravelDocsPreparationViewModel.swift
//  galaxy
//
//  Created by davidhuangA on 2024/8/26.
//  Copyright © 2024 https://www.galaxy-immi.com. All rights reserved.
//

import UIKit
import AttributedString

class YHTravelDocsPreparationViewModel: YHBaseViewModel {
    
    //列表信息
    var arrTravelDocs : [YHTravelDocsPreparationListModel?] = []
    
    //旅行证件嫌弃
    var travelDetailModel : YHTravelDocsPreparationDetailModel?
    
}

extension YHTravelDocsPreparationViewModel {
    
    //获取旅行证件准备列表
    func getTravelDocsList(param : [String:Any],callBackBlock:@escaping (_ success: Bool,_ err:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.TravelDocsPreparation.getTravelDocsListApi
        let _ = YHNetRequest.getRequest(url: strUrl,params:param) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [Any],let list = [YHTravelDocsPreparationListModel].deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    self.arrTravelDocs = []
                    callBackBlock(false, err)
                    return
                }
                self.arrTravelDocs = list
                callBackBlock(true, nil)
                
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false,err)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
    //获取旅行证件详情
    func getTravelDocsDetailInfo(param : [String:Any],callBackBlock:@escaping (_ success: Bool,_ err:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.TravelDocsPreparation.getTravelDocsDetailApi
        let _ = YHNetRequest.getRequest(url: strUrl,params:param) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else { return }
            printLog("model 是 ==> \(json)")
            
            if json.code == 200 {
                guard let dic = json.data?.peel as? [String : Any], let resultModel = YHTravelDocsPreparationDetailModel.deserialize(from: dic) else {
                    let err = YHErrorModel(errorCode: YHErrorCode.dictParseError.rawValue, errorMsg: YHErrorCode.dictParseError.description())
                    self.travelDetailModel = nil
                    callBackBlock(false, err)
                    return
                }
                self.travelDetailModel = resultModel
                for item in resultModel.list {
                    if let item = item {
                        item.latest_validaty_date = self.travelDetailModel?.latest_validaty_date ?? ""
                        item.china_travel_latest_validaty_date = self.travelDetailModel?.china_travel_latest_validaty_date ?? ""
                        item.age = resultModel.age
                    }
                }
                callBackBlock(true, nil)
                
            } else {
                self.travelDetailModel = nil
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false,err)
            }
        } failBlock: { err in
            self.travelDetailModel = nil
            callBackBlock(false,err)
        }
    }
    
    //保存旅行证件
    func saveTravelDocsInfo(params: [String: Any], callBackBlock:@escaping (_ success: Bool,_ error:YHErrorModel?)->()) {
        let strUrl = YHBaseUrlManager.shared.curURL() + YHAllApiName.TravelDocsPreparation.saveTravelDocsInfoApi
        
        let _ = YHNetRequest.postRequest(url: strUrl, params: params) { [weak self] json, code in
            //1. json字符串 转 对象
            guard let self = self else {
                callBackBlock(false,nil)
                return
            }
            
            if json.code == 200 {
                
                callBackBlock(true,nil)
            } else {
                let err = YHErrorModel(errorCode: Int32(json.code), errorMsg: json.msg.isEmpty ? "" : json.msg)
                callBackBlock(false,err)
            }
        } failBlock: { err in
            callBackBlock(false,err)
        }
    }
    
}


extension YHTravelDocsPreparationViewModel {
    
    func getTextWithType(type: Int, date:String) -> ASAttributedString  {
        
        if type ==  0 {
           return .init("上传《港澳通行证》(需有效期≥\(date))", .font(UIFont.PFSC_R(ofSize:14)),.foreground(UIColor.mainTextColor(alpha: 0.5)))
        }
        
        if type == 1 {
            let a = ASAttributedString.init("办理逗留D签注", .font(UIFont.PFSC_R(ofSize:14)), .foreground(UIColor.mainTextColor(alpha: 0.5)))
            let b = ASAttributedString.init("《", .font(UIFont.PFSC_R(ofSize:14)),.foreground(UIColor.brandMainColor))
            let c = ASAttributedString.init("港澳通行证逗留 (D) -办理操作指引", .font(UIFont.PFSC_R(ofSize:14)),
                .underline([.single]),
                .foreground(UIColor.brandMainColor),
                .action {
                    YHTravelHKDLGuideSheetView.sheetView().show()
            })
            let d = ASAttributedString.init("》", .font(UIFont.PFSC_R(ofSize:14)),.foreground(UIColor.brandMainColor))
            let e = ASAttributedString.init("点击查看", .font(UIFont.PFSC_R(ofSize:14)),.foreground(UIColor.mainTextColor(alpha: 0.5)))
            return a+b+c+d+e
        }
        
        if type == 2 {
            return .init("上传《护照》(需有效期≥\(date))", .font(UIFont.PFSC_R(ofSize:14)),.foreground(UIColor.mainTextColor(alpha: 0.5)))
        }
        
        if type == 3 {
            return .init("上传《护照》(需有效期≥\(date))", .font(UIFont.PFSC_R(ofSize:14)),.foreground(UIColor.mainTextColor(alpha: 0.5)))
        }
        
        if type == 4 {
            return .init("上传中国居留许可签证", .font(UIFont.PFSC_R(ofSize:14)),.foreground(UIColor.mainTextColor(alpha: 0.5)))
        }
        return .init("", .font(UIFont.PFSC_R(ofSize:14)),.foreground(UIColor.mainTextColor(alpha: 0.5)))
    }
    
    func getTipsWithType(_ type: YHTravelDocsType, date: String) -> [ASAttributedString] {
        
        if type == .HK {
            return [self.getTextWithType(type: 0, date: date),
                    self.getTextWithType(type: 1, date: date),]
        }
        
        if type == .chinesePassPort {
            return [self.getTextWithType(type: 2, date: date),]
        }
        
        if type == .forignPassPort {
            return [self.getTextWithType(type: 3, date: date),
                    self.getTextWithType(type: 4, date: date),]
        }
        
        return []
    }
    
}
